/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.mixin.fml.client;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.resources.IResourcePack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.ForgeVersion;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.client.GuiModList;
import net.minecraftforge.fml.client.GuiScrollingList;
import net.minecraftforge.fml.client.IModGuiFactory;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import noppes.npcs.LogWriter;
import noppes.npcs.util.Util;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={GuiModList.class}, remap=false, priority=499)
public class GuiModListMixin {
    @Shadow
    private GuiButton configModButton;
    @Shadow
    private GuiButton disableModButton;
    @Shadow
    private GuiScrollingList modInfo;
    @Shadow
    private ModContainer selectedMod;
    @Shadow
    private int listWidth;
    @Unique
    private Constructor<?> npsc$infoConstructor;

    /*
     * WARNING - void declaration
     */
    @Inject(method={"updateCache"}, at={@At(value="HEAD")}, cancellable=true)
    public void npcs$updateCache(CallbackInfo ci) {
        try {
            Minecraft mc = Minecraft.func_71410_x();
            this.configModButton.field_146125_m = false;
            this.disableModButton.field_146125_m = false;
            this.modInfo = null;
            if (this.selectedMod == null) {
                return;
            }
            ResourceLocation logoPath = null;
            Dimension logoDims = new Dimension(0, 0);
            ArrayList<String> lines = new ArrayList<String>();
            ForgeVersion.CheckResult verCheck = ForgeVersion.getResult((ModContainer)this.selectedMod);
            String logoFile = this.selectedMod.getMetadata().logoFile;
            if (!logoFile.isEmpty()) {
                TextureManager tm = mc.func_110434_K();
                IResourcePack pack = FMLClientHandler.instance().getResourcePackFor(this.selectedMod.getModId());
                try {
                    void var10_14;
                    Object var10_11 = null;
                    if (pack != null) {
                        BufferedImage bufferedImage = pack.func_110586_a();
                    } else {
                        InputStream logoResource = this.getClass().getResourceAsStream(logoFile);
                        if (logoResource != null) {
                            BufferedImage bufferedImage = TextureUtil.func_177053_a((InputStream)logoResource);
                        }
                    }
                    if (var10_14 != null) {
                        logoPath = tm.func_110578_a("modlogo", new DynamicTexture((BufferedImage)var10_14));
                        logoDims = new Dimension(var10_14.getWidth(), var10_14.getHeight());
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            String updateLineText = new TextComponentTranslation("forge.mod.update.available", new Object[0]).func_150254_d() + TextFormatting.DARK_AQUA + (verCheck.url == null ? "" : verCheck.url);
            if (!this.selectedMod.getMetadata().autogenerated) {
                String currentLanguage;
                this.disableModButton.field_146125_m = true;
                this.disableModButton.field_146124_l = true;
                this.disableModButton.packedFGColour = 0;
                Class<?>[] disableable = this.selectedMod.canBeDisabled();
                if (disableable == ModContainer.Disableable.RESTART) {
                    this.disableModButton.packedFGColour = new Color(0xFF3377).getRGB();
                } else if (disableable != ModContainer.Disableable.YES) {
                    this.disableModButton.field_146124_l = false;
                }
                IModGuiFactory iModGuiFactory = FMLClientHandler.instance().getGuiFactoryFor(this.selectedMod);
                this.configModButton.field_146125_m = true;
                this.configModButton.field_146124_l = false;
                if (iModGuiFactory != null) {
                    this.configModButton.field_146124_l = iModGuiFactory.hasConfigGui();
                }
                if (this.selectedMod.getMetadata().modId.equals("customnpcs")) {
                    lines.add(TextFormatting.GOLD + "Custom NPCs" + TextFormatting.DARK_GREEN + " Unofficial");
                } else {
                    lines.add(this.selectedMod.getMetadata().name);
                }
                lines.add(new TextComponentTranslation("forge.mod.version", new Object[0]).func_150254_d() + " " + this.selectedMod.getDisplayVersion() + " (" + this.selectedMod.getVersion() + ")");
                lines.add(TextFormatting.GRAY + "Mod ID: " + TextFormatting.BLUE + this.selectedMod.getModId());
                lines.add(TextFormatting.GRAY + "Mod State: " + TextFormatting.GOLD + Loader.instance().getModState(this.selectedMod).toString());
                if (!this.selectedMod.getMetadata().credits.isEmpty()) {
                    lines.add(new TextComponentTranslation("forge.mod.credits", new Object[0]).func_150254_d() + " " + TextFormatting.AQUA + this.selectedMod.getMetadata().credits);
                }
                StringBuilder authors = new StringBuilder();
                int i = 0;
                for (String name : this.selectedMod.getMetadata().authorList) {
                    authors.append(TextFormatting.GREEN).append(name);
                    if (i < this.selectedMod.getMetadata().authorList.size() - 1) {
                        authors.append(TextFormatting.GRAY).append(", ");
                    }
                    ++i;
                }
                lines.add(new TextComponentTranslation("forge.mod.authors", new Object[0]).func_150254_d() + " " + authors);
                lines.add(TextFormatting.GRAY + "URL: " + this.selectedMod.getMetadata().url);
                if (this.selectedMod.getMetadata().childMods.isEmpty()) {
                    lines.add(new TextComponentTranslation("forge.mod.no.child", new Object[0]).func_150254_d());
                } else {
                    lines.add(new TextComponentTranslation("forge.mod.child", new Object[0]).func_150254_d() + " " + this.selectedMod.getMetadata().getChildModList());
                }
                if (verCheck.status == ForgeVersion.Status.OUTDATED || verCheck.status == ForgeVersion.Status.BETA_OUTDATED) {
                    lines.add(updateLineText);
                }
                lines.add(null);
                String description = new TextComponentTranslation(this.selectedMod.getMetadata().description, new Object[0]).func_150254_d();
                if (Util.instance.equalsDeleteColor(description, this.selectedMod.getMetadata().description, false) && !(currentLanguage = mc.func_135016_M().func_135041_c().func_135034_a()).equals("en_us")) {
                    String language = currentLanguage;
                    if (currentLanguage.contains("_")) {
                        language = currentLanguage.equals("zh_cn") ? "zh_CN" : (currentLanguage.equals("zh_tw") ? "zh_TW" : currentLanguage.substring(0, currentLanguage.indexOf("_")));
                    }
                    description = Util.instance.translateGoogle("auto", language, description);
                }
                lines.add(description);
            } else {
                lines.add(TextFormatting.WHITE + this.selectedMod.getName());
                lines.add(new TextComponentTranslation("forge.mod.version", new Object[0]).func_150254_d() + " " + this.selectedMod.getVersion());
                lines.add(TextFormatting.GRAY + "Mod State: " + TextFormatting.GOLD + Loader.instance().getModState(this.selectedMod));
                if (verCheck.status == ForgeVersion.Status.OUTDATED || verCheck.status == ForgeVersion.Status.BETA_OUTDATED) {
                    lines.add(updateLineText);
                }
                lines.add(null);
                lines.add(new TextComponentTranslation("forge.mod.no.found", new Object[0]).func_150254_d());
                lines.add(new TextComponentTranslation("forge.mod.ask.author", new Object[0]).func_150254_d());
            }
            if (!(verCheck.status != ForgeVersion.Status.OUTDATED && verCheck.status != ForgeVersion.Status.BETA_OUTDATED || verCheck.changes.isEmpty())) {
                lines.add(null);
                lines.add(new TextComponentTranslation("forge.mod.changes", new Object[0]).func_150254_d());
                for (Map.Entry entry : verCheck.changes.entrySet()) {
                    lines.add("  " + entry.getKey() + ":");
                    lines.add(new TextComponentTranslation((String)entry.getValue(), new Object[0]).func_150254_d());
                    lines.add(null);
                }
            }
            if (this.npsc$infoConstructor == null) {
                for (Class<?> subclass : GuiModList.class.getDeclaredClasses()) {
                    if (!subclass.getSimpleName().equals("Info")) continue;
                    this.npsc$infoConstructor = subclass.getConstructor(GuiModList.class, Integer.TYPE, List.class, ResourceLocation.class, Dimension.class);
                    break;
                }
            }
            if (this.npsc$infoConstructor != null) {
                GuiModList parent = (GuiModList)this;
                this.modInfo = (GuiScrollingList)this.npsc$infoConstructor.newInstance(parent, parent.field_146294_l - this.listWidth - 30, lines, logoPath, logoDims);
                ci.cancel();
            }
        }
        catch (Exception e) {
            LogWriter.error(e);
        }
    }
}

